<?php
declare(strict_types=1);

// --------------------------------------------------
// RadioDJ Now Playing JSON endpoint
// --------------------------------------------------

// Make sure DB details match your main index.php
$dsn  = 'mysql:host=87.102.0.87:3307;dbname=radiodj;charset=utf8mb4';
$user = 'RadioDJuser';
$pass = 'radiodjpassword';

header('Content-Type: application/json; charset=utf-8');

try {
    $pdo = new PDO($dsn, $user, $pass, [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);

    // RadioDJ history -> most recent played track
    $stmt = $pdo->prepare("
        SELECT artist, title
        FROM history
        WHERE song_type = 0
        ORDER BY ID DESC
        LIMIT 1
    ");
    $stmt->execute();

    $row = $stmt->fetch();

    if ($row) {
        echo json_encode([
            'artist' => $row['artist'] ?: '',
            'title'  => $row['title']  ?: ''
        ]);
    } else {
        echo json_encode([
            'artist' => '',
            'title'  => ''
        ]);
    }
} catch (Throwable $e) {
    echo json_encode([
        'artist' => '',
        'title'  => ''
    ]);
}
