<?php
declare(strict_types=1);

require_once "config.php";

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
$DEFAULT_ART = "assets/imgs/noartistimg.png";
function curlGet(string $url): ?string {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT        => 5,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_USERAGENT      => "Mozilla/5.0"
    ]);
    $out = curl_exec($ch);
    curl_close($ch);
    return $out ?: null;
}
function lookupArtwork(string $artist, string $title, string $fallback): string {
    $query = urlencode("$artist $title");

    $url = "https://itunes.apple.com/search?media=music&limit=1&term=$query";

    $json = curlGet($url);
    if (!$json) return $fallback;

    $data = json_decode($json, true);
    if (empty($data['results'][0])) return $fallback;

    $art = $data['results'][0]['artworkUrl100'] ?? "";

    return $art ? str_replace("100x100", "600x600", $art) : $fallback;
}
try {
    $stmt = $pdo_cbr->prepare("
        SELECT trackID, artist, title
        FROM history
        WHERE song_type = 0
        ORDER BY date_played DESC
        LIMIT 1
    ");
    $stmt->execute();
    $row = $stmt->fetch();

    if (!$row) {
        echo json_encode([
            "artist"  => SITE_NAME,
            "title"   => "Streaming Live",
            "artwork" => $DEFAULT_ART,
            "stream"  => sc_build_stream_url(),
            "source"  => "empty-history"
        ]);
        exit;
    }

    $trackID = (int)$row['trackID'];
    $artist  = trim($row['artist']);
    $title   = trim($row['title']);

    $safeArtist = preg_replace('/[^A-Za-z0-9 _.-]/', '', $artist);
    $localArt   = "AlbumArt/" . $safeArtist . ".jpg";

    $artwork = file_exists($localArt) ? $localArt : null;

    if (!$artwork) {
        $artwork = lookupArtwork($artist, $title, $DEFAULT_ART);
    }

$stmtReq = $pdo_cbr->prepare("
    SELECT username, message
    FROM requests
    WHERE songID = :id
      AND requested > NOW() - INTERVAL 3 HOUR
    ORDER BY requested DESC
    LIMIT 1
");
$stmtReq->execute([':id' => $trackID]);
$req = $stmtReq->fetch();

$requestedBy = $req['username'] ?? null;
$requestMsg  = $req['message'] ?? null;

    // 5) OUTPUT JSON
    echo json_encode([
        "artist"      => $artist,
        "title"       => $title,
        "artwork"     => $artwork,
        "requestedBy" => $requestedBy,
	"requestMsg"  => $requestMsg,
        "stream"      => sc_build_stream_url(),
        "timestamp"   => time(),
        "source"      => "history"
    ]);
    exit;

} catch (Throwable $e) {

    echo json_encode([
        "artist"  => SITE_NAME,
        "title"   => "Unavailable",
        "artwork" => $DEFAULT_ART,
        "stream"  => sc_build_stream_url(),
        "error"   => $e->getMessage(),
        "source"  => "error"
    ]);
    exit;
}
