<?php
declare(strict_types=1);

require_once "../config.php";

header('Content-Type: application/json');

// Read JSON from fetch()
$data = json_decode(file_get_contents("php://input"), true);

$songID   = (int)($data["id"] ?? 0);
$username = trim($data["name"] ?? "CheddarBeats Listener");
$message  = trim($data["message"] ?? "");

if ($songID < 1) {
    echo json_encode(["success" => false, "message" => "Invalid song ID"]);
    exit;
}

try {
    /* Insert into RADIO DJ (your only DB connection = $pdo_cbr) */
    $stmt = $pdo_cbr->prepare("
        INSERT INTO requests (songID, username, userIP, message, requested, played)
        VALUES (:songID, :username, :userIP, :message, NOW(), 0)
    ");

    $stmt->execute([
        ':songID'   => $songID,
        ':username' => $username,
        ':userIP'   => $_SERVER['REMOTE_ADDR'],
        ':message'  => $message
    ]);

    echo json_encode([
        "success" => true,
        "message" => "Your request has been added, $username!"
    ]);

} catch (Exception $e) {
    file_put_contents("request_error.log", $e->getMessage() . "\n", FILE_APPEND);
    echo json_encode([
        "success" => false,
        "message" => "Database error: " . $e->getMessage()
    ]);
}
