<?php
declare(strict_types=1);
require_once "../config.php";

header("Content-Type: text/html; charset=utf-8");

/* -----------------------------------------
   PARAMETERS
------------------------------------------ */
$perPage = 48;
$page    = isset($_GET["p"]) ? max(1, intval($_GET["p"])) : 1;
$offset  = ($page - 1) * $perPage;

$q = isset($_GET["q"]) ? trim($_GET["q"]) : "";
$qLike = "%" . $q . "%";

/* -----------------------------------------
   WHERE CLAUSE
------------------------------------------ */
$where = "WHERE enabled = 1";
$params = [];

if ($q !== "") {
    $where .= " AND (artist LIKE :q OR title LIKE :q)";
    $params[":q"] = $qLike;
}

/* -----------------------------------------
   COUNT TOTAL SONGS
------------------------------------------ */
$sqlCount = "SELECT COUNT(*) FROM songs $where";
$stmtTotal = $pdo_cbr->prepare($sqlCount);
$stmtTotal->execute($params);
$totalSongs = (int)$stmtTotal->fetchColumn();

$totalPages = max(1, ceil($totalSongs / $perPage));

/* -----------------------------------------
   FETCH SONGS
------------------------------------------ */
$sql = "
    SELECT ID, artist, title
    FROM songs
    $where
    ORDER BY artist ASC, title ASC
    LIMIT :offset, :pp
";

$stmt = $pdo_cbr->prepare($sql);

foreach ($params as $k => $v) {
    $stmt->bindValue($k, $v, PDO::PARAM_STR);
}

$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->bindValue(':pp', $perPage, PDO::PARAM_INT);

$stmt->execute();
$songs = $stmt->fetchAll(PDO::FETCH_ASSOC);

/* -----------------------------------------
   PAGINATION FUNCTION
------------------------------------------ */
function renderPagination($page, $totalPages) {

    echo "<div class='cb-pagination'>";

    // Prev
    if ($page > 1) {
        echo "<a href='#' onclick='goPage(" . ($page - 1) . ");return false;'>&#9664; Prev</a>";
    }

    // Number window
    $start = max(1, $page - 2);
    $end   = min($totalPages, $page + 2);

    // 1 ...
    if ($start > 1) {
        echo "<a href='#' onclick='goPage(1);return false;'>1</a>";
        if ($start > 2) echo "<span class='dots'>...</span>";
    }

    for ($i = $start; $i <= $end; $i++) {
        if ($i == $page) {
            echo "<span class='active'>$i</span>";
        } else {
            echo "<a href='#' onclick='goPage($i);return false;'>$i</a>";
        }
    }

    // ... last
    if ($end < $totalPages) {
        if ($end < $totalPages - 1) echo "<span class='dots'>...</span>";
        echo "<a href='#' onclick='goPage($totalPages);return false;'>$totalPages</a>";
    }

    // Next
    if ($page < $totalPages) {
        echo "<a href='#' onclick='goPage(" . ($page + 1) . ");return false;'>Next &#9654;</a>";
    }

    echo "</div>";
}

/* -----------------------------------------
   SHOW TOP PAGINATION
------------------------------------------ */
renderPagination($page, $totalPages);

/* -----------------------------------------
   OUTPUT SONG GRID
------------------------------------------ */
echo "<div class='row row--grid'>";

if (empty($songs)) {
    echo "
    <div class='col-12'>
        <div class='no-results' style='padding:20px;text-align:center;opacity:0.8;'>
            No results found.
        </div>
    </div>";
} else {
    foreach ($songs as $s):

        $id     = $s["ID"];
        $artist = htmlspecialchars($s["artist"]);
        $title  = htmlspecialchars($s["title"]);

        // Artwork fallback
        $art = getArtwork($s["artist"], $s["title"]);
        if (!$art) $art = "assets/imgs/noartistimg.png";

        $safeArtist = addslashes($artist);
        $safeTitle  = addslashes($title);
?>
        <div style="margin-bottom:30px;" class="col-6 col-sm-4 col-lg-2 songfade">
            <div class="album">

                <div class="album__cover">
                    <img src="<?= $art ?>" alt="<?= $artist ?>">
                    <a href="#" onclick="openRequestModal(<?= $id ?>, '<?= $safeArtist ?> - <?= $safeTitle ?>'); return false;"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M18.54,9,8.88,3.46a3.42,3.42,0,0,0-5.13,3V17.58A3.42,3.42,0,0,0,7.17,21a3.43,3.43,0,0,0,1.71-.46L18.54,15a3.42,3.42,0,0,0,0-5.92Zm-1,4.19L7.88,18.81a1.44,1.44,0,0,1-1.42,0,1.42,1.42,0,0,1-.71-1.23V6.42a1.42,1.42,0,0,1,.71-1.23A1.51,1.51,0,0,1,7.17,5a1.54,1.54,0,0,1,.71.19l9.66,5.58a1.42,1.42,0,0,1,0,2.46Z"/></svg></a>
                </div>
                <div class="album__title">
                    <h3><a href="#" onclick="return false;"><?= $title ?></a></h3>
                    <span><?= $artist ?></span>
                </div>

            </div>
        </div>
<?php
    endforeach;
}

echo "</div>";

/* -----------------------------------------
   SHOW BOTTOM PAGINATION
------------------------------------------ */
renderPagination($page, $totalPages);

exit;
?>
