<?php
declare(strict_types=1);
require_once "../config.php";

header('Content-Type: application/json; charset=utf-8');

/* ---------------------------------------------------------
   SELECT MODE
--------------------------------------------------------- */
$mode = $_GET["mode"] ?? "random";

switch ($mode) {

    case "random":
        $stmt = $pdo_cbr->query("
            SELECT ID, artist, title
            FROM songs
            WHERE enabled = 1
            ORDER BY RAND()
            LIMIT 24
        ");
        break;
    default:
        echo json_encode(["error" => "Invalid mode"]);
        exit;
}

$songs = $stmt->fetchAll(PDO::FETCH_ASSOC);

/* ---------------------------------------------------------
   ARTWORK LOOKUP (Local ? iTunes ? Default)
--------------------------------------------------------- */
foreach ($songs as &$s) {
    $s["artwork"] = getArtwork($s["artist"], $s["title"]);
}

echo json_encode($songs, JSON_UNESCAPED_SLASHES);
