<!-- footer -->
<div class="footer">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="footer__content">

                    <div class="footer__social">
                        <!-- socials -->
                    </div>

                    <small class="footer__copyright">
                        Copyright <?php echo SITE_NAME; ?> <?php echo date('Y'); ?> -
                        Powered by <a href="https://www.radiodj.ro/" target="_blank">RadioDJ.ro</a>
                        | Developed by <a href="https://www.streamcodestudio.com/" target="_blank">StreamCode Studio.com</a>
                    </small>

                </div>
            </div>
        </div>
    </div>
</div>

<!-- REQUEST MODAL -->
<div id="cb-request-modal" class="cb-modal hidden">
    <div class="cb-modal-box">
        <h3 id="cb-modal-title">Request This Song</h3>
        <p id="cb-modal-song" class="cb-song-info">Song Title Here</p>

        <label>Your Name (optional)</label>
        <input type="text" id="cb-req-name" placeholder="Listener">

        <label>Your Message / Dedication (optional)</label>
        <textarea id="cb-req-message" placeholder="Type a fun dedication..."></textarea>

        <div class="cb-modal-buttons">
            <button id="cb-modal-cancel">Cancel</button>
            <button id="cb-modal-send" class="send">Send Request</button>
        </div>
    </div>
</div>

<!-- =====================================================
     JAVASCRIPT
===================================================== -->

<script src="assets/js/cb-player.js"></script>

<!-- Vendor JS -->
<script src="assets/js/bootstrap.bundle.min.js"></script>
<script src="assets/js/owl.carousel.min.js"></script>
<script src="assets/js/jquery.magnific-popup.min.js"></script>
<script src="assets/js/smooth-scrollbar.js"></script>
<script src="assets/js/select2.min.js"></script>
<script src="assets/js/jquery.inputmask.min.js"></script>
<script src="assets/js/main.js"></script>
<script src="assets/js/home.js"></script>
<script src="assets/js/request.js"></script>
<!-- =====================================================
     REQUEST MODAL JS (global)
===================================================== -->
<script>
window.openRequestModal = function(songID, songTitle) {
    currentSongID = songID;
    currentSongTitle = songTitle;

    document.getElementById("cb-modal-song").textContent = songTitle;
    document.getElementById("cb-request-modal").classList.add("show");
};

document.getElementById("cb-modal-cancel").addEventListener("click", () => {
    document.getElementById("cb-request-modal").classList.remove("show");
});

document.getElementById("cb-modal-send").addEventListener("click", () => {
    const name    = document.getElementById("cb-req-name").value.trim() || "Listener request";
    const message = document.getElementById("cb-req-message").value.trim();

    fetch("liveincs/send_request.php", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({
            id: currentSongID,
            name: name,
            message: message
        })
    })
.then(data => {

    const modal = document.getElementById("cb-request-modal");
    const title = document.getElementById("cb-modal-title");
    const song  = document.getElementById("cb-modal-song");

    // Show confirmation inside modal
    title.textContent = "Request Sent!";
    song.textContent  = "Your track will be added shortly";

    // Hide input fields + buttons
    document.getElementById("cb-req-name").style.display = "none";
    document.getElementById("cb-req-message").style.display = "none";
    document.querySelector(".cb-modal-buttons").style.display = "none";


    setTimeout(() => {
        // Reset UI
        title.textContent = "Request This Song";
        song.textContent = currentSongTitle;

        document.getElementById("cb-req-name").value = "";
        document.getElementById("cb-req-message").value = "";

        document.getElementById("cb-req-name").style.display = "";
        document.getElementById("cb-req-message").style.display = "";
        document.querySelector(".cb-modal-buttons").style.display = "";

        // Close modal
        modal.classList.remove("show");

    }, 4000);

})
    .catch(err => {
        showRequestPopup("Error sending request.");
    });
});
</script>
</body>
</html>
