<?php
declare(strict_types=1);
// No whitespace above this linevery important
// Readthe README SETUP File if you need help 
date_default_timezone_set('Europe/London');

define('SITE_NAME',  'CheddarBeats Radio');

/* ============================================================
   DATABASE (PDO)
============================================================ */
define('DATAB_HOST',  'localhost');
define('DATAB_PORT',  '3306');
define('DATAB_DB',    'radiodj-database');
define('DATAB_UNAME', 'radiodj-user');
define('DATAB_PASS',  'radiodj-password');

$dsn = "mysql:host=" . DATAB_HOST . ";port=" . DATAB_PORT . ";dbname=" . DATAB_DB . ";charset=utf8mb4";

try {
    $pdo_cbr = new PDO($dsn, DATAB_UNAME, DATAB_PASS, [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,   // FIXED
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_PERSISTENT         => true,
    ]);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}
/* ============================================================
   SHOUTCAST CONFIG
============================================================ */
define('SC_URL_IP',  'uk2-pn.mixstream.net');
define('SC_PORTNM',  'Port-Number');
define('SC_SID',     '1');
define('SC_MOUNT',   ';');
define('SC_URLEX',   'stream');
define('SC_SSL',     'https');
function sc_build_stream_url(): string {
    return (SC_SSL === 'https' ? 'https://' : 'http://')
        . SC_URL_IP . '/' . SC_PORTNM . '/listen.mp3';
}

/* ============================================================
============================================================ */
function getArtwork(string $artist, string $title = "", string $defaultArt = ""): string {

    // Default fallback image
    if (!$defaultArt) {
        $defaultArt = "assets/imgs/noartistimg.png";
    }
    // Normalise filename
    $safeArtist = strtolower(trim(preg_replace('/[^A-Za-z0-9]/', '_', $artist)));

    // Absolute server path
    $localFile = $_SERVER['DOCUMENT_ROOT'] . "/AlbumArt/" . $safeArtist . ".jpg";

    // URL path for the frontend
    $urlPath   = "/AlbumArt/" . $safeArtist . ".jpg";

    if (file_exists($localFile)) {
        return $urlPath;
    }
    $query = urlencode(trim("$artist $title"));
    if (!$title) {
        $query = urlencode($artist);
    }
    $itunesURL = "https://itunes.apple.com/search?media=music&limit=1&term=$query";
    $ch = curl_init($itunesURL);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_TIMEOUT => 4,
        CURLOPT_USERAGENT => "Mozilla/5.0"
    ]);
    $json = curl_exec($ch);
    curl_close($ch);

    if ($json) {
        $data = json_decode($json, true);

        if (!empty($data["results"][0]["artworkUrl100"])) {
            return str_replace("100x100", "600x600", $data["results"][0]["artworkUrl100"]);
        }
    }

    return $defaultArt;
}
