document.addEventListener("pjax:complete", initRequestPage);
document.addEventListener("DOMContentLoaded", initRequestPage);

function initRequestPage() {
    const resultsBox = document.getElementById("requestResults");
    if (!resultsBox) return;

    // Load default list
    loadRequestResults(1);
}

function loadRequestResults(page = 1) {
    const resultsBox = document.getElementById("requestResults");
    const loader = document.getElementById("cb-loader");

    if (!resultsBox || !loader) return;

    loader.style.display = "block";
    resultsBox.style.opacity = "0.2";

    fetch(`liveincs/request_list.live.php?p=${page}&t=${Date.now()}`)
        .then(r => r.text())
        .then(html => {
            resultsBox.innerHTML = html;

            loader.style.display = "none";

            resultsBox.animate(
                [{ opacity: 0.2 }, { opacity: 1 }],
                { duration: 250, fill: "forwards" }
            );
        });
}

// Pagination
function goPage(page) {
    loadRequestResults(page);
}
