document.addEventListener("DOMContentLoaded", initXR);
document.addEventListener("pjax:complete", initXR);

let xrIntervals = {};

function initXR() {

    // Prevent duplicate timers each navigation
    clearAllXRIntervals();

    // HOME: Random Songs
    if (document.getElementById("random-songs")) {
        loadRandomSongs();
        xrIntervals.random = setInterval(loadRandomSongs, 40000);
    }
}
function clearAllXRIntervals() {
    for (let key in xrIntervals) {
        clearInterval(xrIntervals[key]);
    }
    xrIntervals = {};
}
function loadRandomSongs(mode = "random") {

    const block = document.getElementById("random-songs");
    if (!block) return;

    $("#random-songs").css("opacity", "0.2");

    fetch("liveincs/randomsongs.live.php?mode=" + mode + "&t=" + Date.now())
        .then(r => r.json())
        .then(songs => {

            let html = "";

            songs.forEach(song => {
                let safeTitle = song.title.replace(/"/g, "&quot;").replace(/'/g, "\\'");
                let safeArtist = song.artist.replace(/"/g, "&quot;").replace(/'/g, "\\'");

                html += `
                <div class="col-6 col-sm-4 col-lg-2 songfade">
                    <div class="album">
                        <div class="album__cover">
                            <img src="${song.artwork}" alt="${song.artist}">
                            
                            <a href="#" onclick="openRequestModal(${song.ID}, '${safeArtist} - ${safeTitle}'); return false;"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M18.54,9,8.88,3.46a3.42,3.42,0,0,0-5.13,3V17.58A3.42,3.42,0,0,0,7.17,21a3.43,3.43,0,0,0,1.71-.46L18.54,15a3.42,3.42,0,0,0,0-5.92Zm-1,4.19L7.88,18.81a1.44,1.44,0,0,1-1.42,0,1.42,1.42,0,0,1-.71-1.23V6.42a1.42,1.42,0,0,1,.71-1.23A1.51,1.51,0,0,1,7.17,5a1.54,1.54,0,0,1,.71.19l9.66,5.58a1.42,1.42,0,0,1,0,2.46Z"/></svg></a>
                        </div>

                        <div class="album__title">
                            <h3>
                                <a href="#" onclick="openRequestModal(${song.ID}, '${safeArtist} - ${safeTitle}'); return false;">
                                    ${song.title}
                                </a>
                            </h3>
                            <span>${song.artist}</span>
                        </div>
                    </div>
                </div>`;
            });

            block.innerHTML = html;

            $("#random-songs").animate({opacity: 1}, 300);
            $(".songfade").hide().fadeIn(400);
        })
        .catch(err => console.error("Random Songs Error:", err));
}